-- Edward



set sql_safe_updates=0;


-- SUBMIT_APPLICATION_REFERENCES_RECIPIENTS        
SET @submitApplicationReferenceRecipent=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_REFERENCES_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="select 
    T10.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T10.`referenceName` AS FIRST_NAME,
    T2.`firstName` AS APPLICANT_FIRST_NAME,
    T2.`middleName` AS APPLICANT_MIDDLE_NAME,
    T2.`lastName` AS APPLICANT_LAST_NAME,
    T2.`printName` APPLICANT_FULL_NAME,
    CONCAT(T3.`salutationName`,
            ' ',
            T10.`referenceName`) AS REFEREE_SALUTATION_AND_FULL_NAME,
    T10.`emailId` AS EMAIL_ID,
    T10.`contactNo` AS MOBILE_NO,
    T1.`code` AS APPLICATION_CODE,
    T9.`displayName` AS ACADEMY_NAME_LOCATION,
    T13.`referenceLetterSubmissionDeadline` AS REFERENCE_LETTER_SUBMISSION_DEADLINE,
    T14.`programNameToBePrint` AS PROGRAM_NAME_TO_BE_PRINT,
    T10.`encryptedReferenceId` AS ENCRYPTED_REFERENCE_ID,
     ml.code as LANGUAGE_KEY
from
    application T1
        left outer join
    applicant_person T2 ON T1.applicantPersonId = T2.id
        left outer join
    application_references T10 ON T10.applicationId = T1.id
        left outer join
    salutations T3 ON T3.id = T10.salutationId        
        left outer join
    application_program T8 ON T8.applicationId = T1.id
        left outer join
    programs T14 ON T14.id = T8.programId
        left outer join
    academy_location T9 ON T9.id = T8.academyLocationId
        left outer join
    prog_batch_seat_config T11 ON T11.id = T8.progBatchSeatConfigId
        left outer join
    program_selection_process T12 ON T12.programBatchSeatConfigId = T11.id
        left outer join
    prog_slctn_process_admisn_conf T13 ON T13.programSelectionProcessId = T12.id
    LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id

where
    T10.id in (namedParams)" WHERE `dataProviderId`=@submitApplicationReferenceRecipent;
    
-- APPLICANT_APPOINTMENT_RECIPIENT        
SET @applicantAppointmentRecipent=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_APPOINTMENT_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    sg.id AS ID,
    T1.code AS APPLICANT_CODE,
    T2.firstName AS FIRST_NAME,
    T2.lastName AS LAST_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T2.emailId AS EMAIL_ID,
    T2.mobileNumber AS MOBILE_NO,
    T2.mobileCountryCode AS MOBILE_CODE,
    T4.academyName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl)
	else NULL end) as FOOTER_URL
FROM
    sg_appointment sg
        INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
		LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id
WHERE
    sg.id IN (namedParams)" WHERE `dataProviderId`=@applicantAppointmentRecipent;    



-- PROGRAM_WISE_APPLICATION_APPROVAL_INFO        
SET @programWiseAppicationApproval=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROGRAM_WISE_APPLICATION_APPROVAL_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.id AS ID,
    T6.code AS APPLICATION_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    ml.code as LANGUAGE_KEY,
	(Case when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL,
    (Case when T8.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T8.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.footerUrl)
	else NULL end) as FOOTER_URL
FROM
    application_program T5
        LEFT JOIN
    application T6 ON T6.id = T5.applicationId
        LEFT JOIN
    applicant_person T7 ON T7.id = T6.applicantPersonId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
		LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id
WHERE
    T5.id IN (namedParams)" WHERE `dataProviderId`=@programWiseAppicationApproval;   
     

-- PROGRAM_WISE_APPLICATION_REJECT_INFO        
SET @programWiseAppicationReject=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROGRAM_WISE_APPLICATION_REJECT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.id AS ID,
    T6.code AS APPLICATION_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    ml.code as LANGUAGE_KEY,
	(Case when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL,
    (Case when T8.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T8.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.footerUrl)
	else NULL end) as FOOTER_URL,
	T9.value AS REASON_REJECTION
FROM
    application_program T5
        LEFT JOIN
    application T6 ON T6.id = T5.applicationId
        LEFT JOIN
    applicant_person T7 ON T7.id = T6.applicantPersonId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
		LEFT JOIN
    application_prog_rejection_reasons T9 ON T9.id = T5.rejection_reason_id
		LEFT JOIN
    organizations org on org.id = 1
        LEFT JOIN
    multi_language ml on T7.correspondence_language=ml.id
WHERE
    T5.id IN (namedParams)" WHERE `dataProviderId`=@programWiseAppicationReject; 
    

-- REMINDER_TO_PAY_THE_APPLICATION_FEES_RECIPIENT        
SET @reminderToPayTheApplicatonFee=(SELECT id FROM dtprovider WHERE `dataProviderName`='REMINDER_TO_PAY_THE_APPLICATION_FEES_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select 
    T1.id AS ID,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T1.`code` as APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    ml.code as LANGUAGE_KEY,
    (Case
        when
            T8.logoUrl is null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        when
            T8.logoUrl is null
                and org.orgUrl is null
        then
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        else CONCAT(org.orgUrl, '/', T8.logoUrl)
    end) as LOGO_URL,
    (Case
        when
            T8.headerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        else NULL
    end) as HEADER_URL,
    (Case
        when
            T8.footerUrl is not null
                and org.orgUrl IS NOT NULL
        then
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL
    end) as FOOTER_URL
from
    application T1
        left outer join
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT OUTER JOIN
    application_program T4 ON T4.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T4.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
          LEFT JOIN
    multi_language ml on T2.correspondence_language=ml.id       
 where T1.id in(namedParams)" WHERE `dataProviderId`=@reminderToPayTheApplicatonFee;         


-- APPLICATION_APPROVAL_PARENT_GUARDIAN_RECIPIENT        
SET @applicationApprovalParent=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_APPROVAL_PARENT_GUARDIAN_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T3.id AS ID,
	T3.`code` AS APPLICATION_CODE,
    T4.`firstName` AS FIRST_NAME,
	T4.`middleName` AS MIDDLE_NAME,
    T4.`lastName` AS LAST_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    application T3
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
        LEFT JOIN    
     multi_language ml on T4.correspondence_language=ml.id        
 where T3.id in(namedParams)
		and T5.relationship = 'FATHER'
        and T5.whetherDeleted = false" WHERE `dataProviderId`=@applicationApprovalParent;  


-- COMPLETE_ADMISSION_VELOCITY        
SET @completeAdmissionVelocity=(SELECT id FROM dtprovider WHERE `dataProviderName`='COMPLETE_ADMISSION_VELOCITY_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
        T1.id AS ID,
        T3.printName AS STUDENT_NAME,    
       --  T7.printName AS PARENT_NAME,   
        T3.emailId AS EMAIL_ID,
        T3.mobileNumber AS MOBILE_NO,
        T3.mobileCountryCode AS MOBILE_CODE,
	T3.alternateEmailId AS ALTERNATE_EMAIL_ID,
    ml.code as LANGUAGE_KEY
    FROM
        users T1
            LEFT JOIN
        students T2 ON T1.id = T2.userId
            LEFT JOIN
        persons T3 ON T3.id = T2.personId      
           LEFT JOIN
        multi_language ml on T3.correspondence_language=ml.id
    WHERE
        T1.id IN (namedParams)"  WHERE `dataProviderId`=@completeAdmissionVelocity;  

-- APPROVE_ADMISSION_ADVISOR_INFO        
SET @approveAdmissionAdvisor=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_ADMISSION_ADVISOR_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T13.salutationName AS SALUTATION_NAME,
    T8.firstName AS FIRST_NAME,
    T8.middleName AS MIDDLE_NAME,
    T8.lastName AS LAST_NAME,
    T8.emailId AS EMAIL_ID,
    T8.mobileNumber AS MOBILE_NO,
    T8.mobileCountryCode AS MOBILE_CODE,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T10.batchName AS BATCH_NAME,
    T10.printName AS BATCH_PRINT_NAME,
    T11.programNameToBePrint AS PROGRAM_NAME,
    T12.seatName AS SEAT_NAME,
    T14.academyName AS ACADEMY_NAME,
    T14.locationName AS LOCATION_NAME,
    T14.displayName AS ACADEMY_NAME_LOCATION,
    T14.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    application_admission_detail T1
        INNER JOIN
    application_program T2 ON T1.applicationProgramId = T2.id
        LEFT JOIN
    admission T3 ON T3.applicationAdmissionId = T1.id
        LEFT JOIN
    students T4 ON T4.userId = T3.studentId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    users T6 ON T6.id = T1.advisiorId
        LEFT JOIN
    staffs T7 ON T7.userId = T6.id
        LEFT JOIN
    persons T8 ON T8.id = T7.personId
        LEFT JOIN
    salutations T13 ON T13.id = T8.salutationId
        LEFT JOIN
    prog_batch_seat_config T9 ON T9.id = T1.programBatchSeatConfigId
        LEFT JOIN
    batches T10 ON T10.id = T9.programBatchId
        LEFT JOIN
    programs T11 ON T11.id = T10.programId
        LEFT JOIN
    seat_types T12 ON T12.id = T9.seatTypeId
        LEFT JOIN
    academy_location T14 ON T14.id = T3.academyLocationId
	    LEFT JOIN
    multi_language ml on T8.correspondence_language=ml.id
WHERE
    T1.id = namedParams"  WHERE `dataProviderId`=@approveAdmissionAdvisor;            


-- APPLICATION_FORM_CREATION_OWNER        
SET @applicationOwnerCreation=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICATION_OWNER_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.`id` AS ID,
    T4.`firstName` AS FIRST_NAME,
	T4.`middleName` AS MIDDLE_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`mobileCountryCode` AS MOBILE_CODE,    
    T5.`firstName` AS APPLICANT_FIRSTNAME,
    T5.`middleName` AS APPLICANT_MIDDLENAME,
	T5.`lastName` AS APPLICANT_LASTNAME,
    T7.`displayName` AS ACADEMY_NAME_LOCATION,
    T7.`academyName` AS ACADEMY_NAME,
	T1.`code` as APPLICATION_CODE,
	T9.`primaryeEmailId` AS ACADEMY_EMAILID,
    ml.code as LANGUAGE_KEY
FROM
    application T1
		LEFT JOIN
    users T2 on T1.applicationOwner=T2.id
		LEFT JOIN
    staffs T3 on T2.id=T3.userId
		LEFT JOIN 
    persons T4 on T3.personId=T4.id 
        LEFT JOIN
    applicant_person T5 ON T5.id = T1.applicantPersonId
        LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
        LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId
    LEFT JOIN
    multi_language ml on T4.correspondence_language=ml.id
WHERE
    T1.id IN (namedParams)"  WHERE `dataProviderId`=@applicationOwnerCreation;  
    

-- PROVISIONAL_ADMISSION_COND_DOC        
-- APPLICATION_REJECTION_VELOCITY 
-- PROVISIONAL_ADMISSION_COND_REQ  
-- APPLICATION_REJECTION_POST_ASSESSMENT_VELOCITY
-- TRACKING_APPLICATION_APPLICANT(TRACKING_APPLICATION)
-- APPROVE_REPLACEMENT
-- DIRECT_ADMISSION_CREATION
     
-- RCPNT_TYPE_APPLICANT_DTP        

SET @rcptTypeApplicant=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
   T2.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE, 
   ml.code as LANGUAGE_KEY
FROM
   `application` T1 
   INNER JOIN
      `applicant_person` T2 
      ON T2.id = T1.applicantPersonId 
   LEFT JOIN
      `salutations` T3 
      ON T3.`id` = T2.`salutationId` 
   LEFT JOIN
     multi_language ml on T2.correspondence_language=ml.id    
WHERE
   T2.id IN 
   (
      namedParams
   )"  WHERE `dataProviderId`=@rcptTypeApplicant;  


-- TRACKING_APPLICATION 
-- TRACKING_APPLICATION_PARENT        

SET @trackingApplication=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_PARENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T3.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    ml.code as LANGUAGE_KEY
FROM
    `application` T1
        INNER JOIN
    `applicant_person_relationships` T2 ON T2.applicantPersonId = T1.applicantPersonId
        INNER JOIN
    `applicant_person` T3 ON T2.relatedApplicantPersonId = T3.id
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
       LEFT JOIN
     multi_language ml on T3.correspondence_language=ml.id   
WHERE
    T3.id IN (namedParams)
GROUP BY T3.id"  WHERE `dataProviderId`=@trackingApplication;    


-- TRIAL_PROVISIONAL_ADMISSION_EXPIRY
-- RCPNT_TYPE_STUDENT_DTP        
SET @rcptTypeStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
     ml.`code` as LANGUAGE_KEY
FROM
    admission T1
        INNER JOIN
    students T2 ON T2.userId = T1.studentId
        INNER JOIN
    `persons` T3 ON T3.id = T2.personId
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
       LEFT JOIN
    multi_language ml on T3.correspondence_language=ml.id
WHERE
    T1.id IN (namedParams) group by T1.id" WHERE `dataProviderId`=@rcptTypeStudent;     


-- TRIAL_PROVISIONAL_ADMISSION_EXPIRY
-- APPROVE_REPLACEMENT
-- DIRECT_ADMISSION_CREATION

-- RCPNT_TYPE_PARENT_GUARDIAN_DTP        
SET @rcptTypeParentGuardian=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_GUARDIAN_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T3.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.`code` as LANGUAGE_KEY
FROM
    `persons` T3
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	 multi_language ml on ml.id = T3.correspondence_language
WHERE
    T3.id IN (namedParams)" WHERE `dataProviderId`=@rcptTypeParentGuardian;     

-- TRIAL_PROVISIONAL_ADMISSION_EXPIRY
-- APPROVE_REPLACEMENT
-- CLOSE_REPLACEMENT
-- DIRECT_ADMISSION_CREATION

-- RCPNT_TYPE_RESOURCE_COORDINATOR_DTP        
SET @rcptTypeResource=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_RESOURCE_COORDINATOR_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.`code` as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
		LEFT JOIN
	 multi_language ml on ml.id = T3.correspondence_language
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@rcptTypeResource;     


-- REPLACEMENT_STUDENT
-- RCPNT_TYPE_USER_DTP        
SET @replaceStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
     ml.`code` as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
        LEFT JOIN
	multi_language ml on ml.id = T3.correspondence_language
WHERE
    T2.id IN (namedParams) group by T1.userId" WHERE `dataProviderId`=@replaceStudent;     

set sql_safe_updates=1;

